@extends('user')
@section('style')

@stop
@section('content')
    @include('partials.breadcrumb')
    <div class="dedicated-plan">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    @include('errors.error')
                    <div class="plan-table">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">@lang('SL')</th>
                                <th scope="col">@lang('Transaction ID')</th>
                                <th scope="col">@lang('Details')</th>
                                <th scope="col">@lang('Amount')</th>
                                <th scope="col">@lang('Remaining Balance')</th>
                                <th scope="col">@lang('Time')</th>
                            </tr>
                            </thead>

                            <tbody>
                            @if(count($invests) >0)
                                @foreach($invests as $k=>$data)
                                    <tr>
                                        <td data-label="@lang('SL')">{{++$k}}</td>
                                        <td data-label="#@lang('TRX')">{{isset($data->trx) ? $data->trx : 'N/A'}}</td>
                                        <td data-label="@lang('Details')">{{  isset($data->title) ? $data->title : 'N/A' }}</td>
                                        <td data-label="@lang('Amount')">

                                            <strong  @if($data->type == '+') style="color: green;" @elseif($data->type == '-') style="color: red;" @endif >
                                                @if($data->type == '+') + @elseif($data->type == '-') - @endif
                                                {{isset($data->amount) ? $data->amount  : 'N/A'}}   {{ $basic->currency }}
                                            </strong>
                                        </td>
                                        <td data-label="@lang('Remaining Balance')"><strong>{{isset($data->main_amo) ? $data->main_amo : ''}}  {{$basic->currency}}</strong></td>
                                        <td data-label="@lang('Time')"> {{date(' d M Y ', strtotime($data->created_at))}} </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="6"> @lang('No Data Found!')</td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div>
                    {!! $invests->links() !!}
                </div>
            </div>
        </div>
    </div>

@stop


